//
//  mesh_functions.hpp
//  test1
//
//  Created by Bac Alexandra on 17/02/2022.
//

#ifndef mesh_functions_hpp
#define mesh_functions_hpp

#include <iostream>
#include <random>
#include "starter_defs.h"
#include <CGAL/IO/Color.h>

using namespace std ;

vector<Mesh::Vertex_index> first_vneighbors(Mesh::Vertex_index v, Mesh &m) ;
vector<Mesh::Face_index> first_fneighbors(Mesh::Vertex_index v, Mesh &m) ;
vector<Mesh::Halfedge_index> first_heneighbors(Mesh::Vertex_index v, Mesh &m) ;

int compute_degrees(Mesh &m, Mesh::Property_map<vertex_descriptor,int> &deg) ;

void gaussian_curv(Mesh &m, Mesh::Property_map<vertex_descriptor,double> &Kcourb) ;

CGAL::Color rand_color(std::uniform_int_distribution<> &distr, std::mt19937 &gen) ;
CGAL::Color color_ramp(double vmin, double vmax, double mean, double stdev, double v, CGAL::Color col1, CGAL::Color col2) ;
K::Point_3 barycenter (const vector<Mesh::Vertex_index> &verts, Mesh &m) ;
vector<face_descriptor> bary_sub(Mesh::Face_index f, Mesh &m) ;
vector<Mesh::Halfedge_index> subdiv_curved(Mesh &m, const Mesh::Property_map<vertex_descriptor,double> &Kcourb, double kmean, double kstdev) ;
vector<Mesh::Halfedge_index> edges_from_faces (vector<Mesh::Halfedge_index> &, Mesh &m);
vector<Mesh::Vertex_index> flip_edges(vector<Mesh::Halfedge_index> &, Mesh &m);
bool test_flip(Mesh::Halfedge_index, Mesh &m) ;
K::Vector_3 laplac_discr(Mesh::Vertex_index v, Mesh &m) ;
void laplac_smooth(vector<Mesh::Vertex_index> l, double lambda, Mesh &m) ;

inline double distance(K::Point_3 p1, K::Point_3 p2) { return sqrt((p2-p1).squared_length()) ;}
inline double sqrd_distance(K::Point_3 p1, K::Point_3 p2) { return ((p2-p1).squared_length()) ;}

#endif /* mesh_functions_hpp */
