//
//  test1.cpp
//  
//
//  Created by Bac Alexandra on 11/02/2022.
//

#include <iostream>
#include <limits>
#include <random>
#include <CGAL/Simple_cartesian.h>
#include <CGAL/Surface_mesh.h>
#include <CGAL/boost/graph/IO/polygon_mesh_io.h>
#include <CGAL/IO/Color.h>
#include <CGAL/Kernel/global_functions.h>
#include "starter_defs.h"
#include "mesh_functions.hpp"
#include "distrib.hpp"
#include "courbures.h"
#include "hole_filling.h"

using namespace std ;

int main(int argc, char** argv)
{
	Mesh m;
	string fname ;
	if (argc != 2)
	{
		cout << "Wrong number of arguments: code_courb filename" << endl ;
		return EXIT_FAILURE;
	}
	else
	{
		fname = argv[1] ;
	}
	
	if(!CGAL::IO::read_polygon_mesh(fname, m))
	{
		std::cerr << "Invalid input file." << std::endl;
		return EXIT_FAILURE;
	}

	std::string out = to_out_file_name(fname) ;
    // Build a MyMesh_Norm containing the mesh with a "normal" property
    MyMesh_Norm mn(m) ;
    // Build a Hole_filling object for the mesh+normals
	Hole_Filling hf(mn) ;
    
    vector<Mesh::Vertex_index> boundary;
    // Compute the implicit surface interpolating 3N points (see TDP4 subject)
    // See fill_hole function for more details
    std::shared_ptr<Implicit_RBF> implicit = hf.fill_hole(boundary) ;
    // Mesh the implicit surface and output to an off file
    hf.output_mesh_implicit(implicit, boundary, "patch.off");
	
	return 0;
}

