//
//  courbures.h
//  code_courb
//
//  Created by Bac Alexandra on 07/04/2022.
//

#ifndef courbures_h
#define courbures_h

#include <stdio.h>
#include <Eigen/Core>
#include <Eigen/Geometry>
#include <Eigen/Dense>
#include "starter_defs.h"


// ////////////////////////////////////////////////////////////////////
// MyMesh
// ////////////////////////////////////////////////////////////////////

class MyMesh {
public:
	Mesh &_m ;
	MyMesh(Mesh &m) : _m(m) {}
} ;

// WARNING
// Property maps are linked to a given mesh so they cannot be duplicated!

// ////////////////////////////////////////////////////////////////////
// MyMesh_Norm
// ////////////////////////////////////////////////////////////////////

class MyMesh_Norm : public MyMesh
{
public:
	// Data
	Mesh::Property_map<vertex_descriptor,K::Vector_3> & vnormal;
    Mesh::Property_map<vertex_descriptor,CGAL::Color> & vcolor;
	
	// Constructors
    MyMesh_Norm(MyMesh_Norm &mn) : MyMesh(mn), vnormal(mn.vnormal), vcolor(mn.vcolor) {};
	MyMesh_Norm(MyMesh &m) ;
    MyMesh_Norm(Mesh &m) ;
    ~MyMesh_Norm() ;
	
    // Methods
	void normales_locales() ;
    virtual void set_fixed_colors() ;
    virtual void output_mesh(const std::string &filename) ;
} ;


// ////////////////////////////////////////////////////////////////////
// Tools
// ////////////////////////////////////////////////////////////////////


inline K::Vector_3 Eig2Cgal_vec(Eigen::VectorXd v) { return K::Vector_3 (v(0),v(1),v(2)) ;}

std::vector<Mesh::Vertex_index> get_two_vneighborhood(Mesh::Vertex_index v, Mesh &m) ;
K::Vector_3 compute_normal(Mesh::Vertex_index v, Mesh &m) ;

#endif /* courbures_hpp */
