#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Polytech Marseille 
IRM 4A

@author: bacalexandra
"""

import numpy as np
import matplotlib.pyplot as plt
import sys
from DeCasteljau import *
from DeCasteljau_tools import *
from picking import *

N = 10

if (len(sys.argv) != 2):
    print('Usage: test_DeCasteljau_surf control_poly_file')
else:
    filename = sys.argv[1]
    P = np.load(filename)
    print(DeCasteljau_surf(P,.5,.5))
    
    fig, ax = plt.subplots(subplot_kw={"projection": "3d"})
    plot_poly_ctrl(P, ax)

