#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Polytech Marseille 
IRM 4A

@author: bacalexandra
"""

import matplotlib.pyplot as plt
import numpy as np

import sys

from matplotlib.image import AxesImage
from matplotlib.text import Text

from PIL import Image

# To start picking, run the picking_loop on an image
# - click on points to pick them
# - press d and enter point index in the consol to delete it
# - press q to quit

# Mouse click event handler
def on_click(event):
    xdata = int(event.xdata)
    ydata = int(event.ydata)
    print('point picked: ', xdata, ydata)
    global coords
    coords.append([xdata, ydata])
    l = len(coords)
    plt.plot([xdata], [ydata], ".")
    plt.annotate(l-1, xy=(xdata, ydata), xytext=(xdata+2, ydata+2))
    plt.show()

# Keyboard press event handler
def on_press(event):
    global coords
    sys.stdout.flush()
    if event.key == 'd':
        i = int(input('Index of the point to remove: '))
        if ((i>=0) and (i < len(coords))):
            del(coords[i])
            plot_scene()
    elif event.key == 'q':
        plt.close()

# Re-plot scene (image + points)
def plot_scene():
    global im, coords
    plt.clf()
    plt.imshow(im)
    plt.text(10,20,'KEYS: d+index in consol: delete a point / q: quit')
    for j in range(len(coords)):
        plt.plot(coords[j][0], coords[j][1], ".")
        plt.annotate(j, xy=(coords[j][0], coords[j][1]), xytext=(coords[j][0]+2, coords[j][1]+2))
    plt.show()

# Main loop
def picking_loop(filename):
    global coords, im, ax
    im = Image.open(filename)
    s = im.size

    fig, ax = plt.subplots()
    plt.imshow(im)
    plt.text(10,20,'KEYS: d+index in consol: delete a point - q: quit')

    coords = []

    cid = fig.canvas.mpl_connect('button_press_event', on_click)
    fig.canvas.mpl_connect('key_press_event', on_press)

    plt.show()
    return np.array(coords)
