#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Polytech Marseille 
IRM 4A

@author: bacalexandra
"""

import numpy as np

# ####### DeCasteljau pour une courbe

# P : tableau numpy de taille d x n
#   d dimension des données
#   n nombre de données

def DeCasteljau(P, t):
    Ptmp = np.copy(P)
    n = Ptmp.shape[0]
    for i in range(n):
        for j in range(n-i-1):
            Ptmp[j,:] = (1-t) * Ptmp[j,:] + t * Ptmp[j+1,:]
    return Ptmp[0,:]
    
# ####### DeCasteljau pour une surface

# P : tableau numpy de taille n x m x d
#   n degré du patch de Bezier selon la 1ère dimension
#   m degré du patch de Bezier selon la 2ème dimension
#   d dimension des données
#
def DeCasteljau_surf(P, u, v):
    ni = P.shape[0]
    nj = P.shape[1]
    d = P.shape[2]
    tmp = np.zeros([ni,d])
    for i in range(ni):
        poly_i = P[i,:,:]
        tmp[i,:]=DeCasteljau(poly_i, v)
    return DeCasteljau(tmp,u)

