//
//  test1.cpp
//  
//
//  Created by Bac Alexandra on 11/02/2022.
//

#include <iostream>
#include <limits>
#include <random>
#include <CGAL/Simple_cartesian.h>
#include <CGAL/Surface_mesh.h>
#include <CGAL/boost/graph/IO/polygon_mesh_io.h>
#include <CGAL/IO/Color.h>
#include <CGAL/Kernel/global_functions.h>
#include "distrib.hpp"
#include "starter_defs.h"
#include "mesh_functions.hpp"

using namespace std ;

int main(int argc, char** argv)
{
	std::random_device rd; // obtain a random number from hardw	are
	std::mt19937 gen(rd()); // seed the generator
	std::uniform_int_distribution<> distr(0, 255); // define the range
	
	Mesh m;
	string fname ;
	if (argc != 2)
	{
		cout << "Wrong number of arguments: test1 filename" << endl ;
		return EXIT_FAILURE;
	}
	else
	{
		fname = argv[1] ;
	}
	
	if(!CGAL::IO::read_polygon_mesh(fname, m))
	{
		std::cerr << "Invalid input file." << std::endl;
		return EXIT_FAILURE;
	}
	
	// Ajout d'une propriété pour la couleur (par sommet)

	Mesh::Property_map<vertex_descriptor,CGAL::Color> color;
	bool created_col;
	boost::tie(color, created_col) = m.add_property_map<vertex_descriptor,CGAL::Color>("v:color",CGAL::Color());
	assert(created_col);
    
    
    Mesh::Vertex_range r = m.vertices();
    // Parcours des sommets et affichage de leurs indices
    for(Mesh::Vertex_range::iterator vit = r.begin(); vit != r.end(); ++vit){
        std::cout << "Vertex index: " << *vit << std::endl;
    }
    
    // Parcours des sommets et affectation d'une couleur aléatoire à chaque sommet
    for (Mesh::Vertex_index vi : r) {
        color[vi] = rand_color(distr, gen);
    }
    
	CGAL::IO::write_polygon_mesh("test.off", m, CGAL::parameters::vertex_color_map(color)) ;
	
	return 0;
}

